@echo off

::###########################
::#  Variables Declaration  #
::###########################
::
:: Variable to change
::
set ted_disk_version=1.1
set batch_version=v1.3
set window_name=CalMAN
set workflow_has_not_black=0
set debug=0

::
:: Variable not to change
::
setlocal EnableDelayedExpansion
set LF=^


set timeout=4
set skip_black=0
set name_program="%~f0"
set cwd=%~dp0
set max=0
set ext=bat

::###########################
::#   Check program name    #
::###########################
echo.%name_program% | findstr /C:"2sec">nul  && (set timeout=4)
echo.%name_program% | findstr /C:"4sec">nul  && (set timeout=6)
echo.%name_program% | findstr /C:"6sec">nul  && (set timeout=8)
echo.%name_program% | findstr /C:"10sec">nul && (set timeout=12)
echo.%name_program% | findstr /C:"black">nul && (set skip_black=1)

::###########################
::#        For Debug        #
::###########################
set log_file=LOG.txt
If %debug% == 1 echo Starting Deug for program %name_program%> LOG.txt

::###########################
::#     Sleep Variables     #
::###########################
set /a usec_menu=1500000
set /a timeout_sleep=%timeout%*1000000

::###########################
::#  Changing working dir   #
::###########################
cd %cwd%

::###########################
::#          Main           #
::###########################
:main
 call :menu

 ::#####################
 ::# Black not skipped #
 ::#####################
 If %skip_black% == 0 (
 call :pattern_to_skip_on_bd
 call :pattern_to_skip_on_calman
 )

 ::#####################
 ::#   Black skipped   #
 ::#####################
 If %skip_black% == 1 (
  call :pattern_to_skip_on_bd_for_black
  call :pattern_to_skip_on_calman_for_black
 )

 ::#####################
 ::# Check the skipped #
 ::#####################
 for /f "tokens=1,2,3,4 delims=, " %%a in ("%skip_bd%") do set uno_bd=%%a & set due_bd=%%b & set tre_bd=%%c & set quattro_bd=%%d
 for /f "tokens=1,2,3,4 delims=, " %%a in ("%skip_c%")  do set uno_c=%%a  & set due_c=%%b  & set tre_c=%%c  & set quattro_c=%%d
 
 ::#####################
 ::#    Loop Section   # 
 ::#####################
 :LOOP
  set entered=0
  set /a i=%i%+1
  call :to_sleep
  ::
  :: Wait for info menu to disappear
  ::
  If %i% == 1 call :sleep_info_disappear
  ::
  ::
  :: Skip Pattern (for example black) on Calman if necessary
  ::
  If %sleep_c% == 1 call :skip_calman_pattern
  :: Wait for black pattern to disappear
  ::
  If %sleep_bd% == 1 call :wait_for_pattern_disappeared
  ::
  :: If skipped black on calman or on bd return to the start of LOOP function 
  ::
  If %entered% == 1 goto :LOOP
  ::
  :: Execute in background read pattern
  ::
  call :read_calman_pattern
  ::
  :: If finished go to menu function
  ::
  If %i% == %max% call :all_is_done
  ::
  :: Sleep
  ::
  call :get_dynamic_sleep
 goto :LOOP
goto :EOF


::###########################
::#      Sub Routines       #
::###########################

::#####################
::# Routines for Menu #
::#####################
::
:: Menu function
::
:menu
 cls
 set i=0
 set max=0
 set /a timeout_pattern=%timeout%-2
 echo  Ted's LightSpace CMS Calibration Disk %ted_disk_version%
 echo  -----------------------------------------
 echo  Automated Procedure for CalMAN 5 Chapters
 echo.
 echo   %timeout_pattern% sec. per Patch Selection (Batch %batch_version%)
 echo. && echo.
 echo. Available Automated Procedure Chapter List
 echo  ------------------------------------------
 echo.
 echo   1. 11-Point Grayscale 
 echo   2. 21-Point Grayscale
 echo   3.  4-Point Saturation 
 echo   4.  4-Point Saturation (for Color Comparator Comparisons Workflow)
 echo   5.  5-Point Saturation
 echo   6.  5-Point Saturation (for Color Comparator Comparisons Workflow)
 echo   7. 10-Point Saturation
 echo   8.  4-Point Luminance 
 echo   9.  4-Point Luminance (for Color Comparator Comparisons Workflow)
 echo  10.  5-Point Luminance
 echo  11.  5-Point Luminance (for Color Comparator Comparisons Workflow)
 echo  12. 10-Point Luminance
 echo  13. Color Checker Classic
 echo  14. Color Checker SG
 echo  15. Color Checker SG Fleshtones 
 for /f %%A in ('"prompt $H&for %%B in (1) do rem"') do set "BS=%%A"
 echo.
 echo |set /p "PR=%BS% Input the number of your selection & press enter key to continue [1-11]: "
 set /p s=
 
 If %s% == 1 set max=12
 If %s% == 2 set max=22
 If %s% == 1 If %skip_black% == 1 set max=11
 If %s% == 2 If %skip_black% == 1 set max=21
 If %s% == 3 set max=26
 If %s% == 4 set max=25
 If %s% == 5 set max=32
 If %s% == 6 set max=31
 If %s% == 7 set max=62
 If %s% == 8 set max=29
 If %s% == 9 set max=25
 If %s% == 10 set max=36
 If %s% == 11 set max=31
 If %s% == 12 set max=71
 If %s% == 13 set max=24
 If %s% == 14 set max=96
 If %s% == 15 set max=19
 echo.
 If %max% == 0 ( 
  echo |set /p "PR=%BS% Attention, wrong Chapter number selected, press a key to return to Chapter List...
  set /p s=
  echo.
  goto :MENU 
 )
 call :get_instructions
 set /P go="%BS% !instructions1!!LF!!LF!!instructions2!"
 call :initialize_variables
 call :get_duration
 if %debug% == 1 echo |set /p=Selecting %window_name% window...>>%log_file%
 start /B /wait cmd /C script\sendkey.%ext% %window_name% "" >nul
 if %debug% == 1 echo done >>%log_file%
:EOF


::#####################
::# Routines for Skip #
::#####################
::
:: Normal Section
::
:: On Calman we usually don't skip patterns
::
:pattern_to_skip_on_bd
 If %s% == 1 set skip_bd=0
 If %s% == 2 set skip_bd=0
 If %s% == 3 set skip_bd=0
 If %s% == 4 set skip_bd=0
 If %s% == 5 set skip_bd=0
 If %s% == 6 set skip_bd=0
 If %s% == 7 set skip_bd=0
 If %s% == 8 set skip_bd=0
 If %s% == 9 set skip_bd=0
 If %s% == 10 set skip_bd=0
 If %s% == 11 set skip_bd=0
 If %s% == 12 set skip_bd=0
 If %s% == 13 set skip_bd=0
 If %s% == 14 set skip_bd=0
 If %s% == 15 set skip_bd=0
goto :EOF

::
:: Normal Section
::
:: On Disk Pattern we usually don't skip patterns
::
:pattern_to_skip_on_calman
 If %s% == 1 set skip_c=0
 If %s% == 2 set skip_c=0
 If %s% == 3 set skip_c=0
 If %s% == 4 set skip_c=0
 If %s% == 5 set skip_c=0
 If %s% == 6 set skip_c=0
 If %s% == 7 set skip_c=0
 If %s% == 8 set skip_c=0
 If %s% == 9 set skip_c=0
 If %s% == 10 set skip_c=0
 If %s% == 11 set skip_c=0
 If %s% == 12 set skip_c=0
 If %s% == 13 set skip_c=0
 If %s% == 14 set skip_c=0
 If %s% == 15 set skip_c=0
goto :EOF

::
:: Without Black Section
::
:: On Disk Pattern we skip black pattern
::
:pattern_to_skip_on_bd_for_black
 If %s% == 1 set skip_bd=1
 If %s% == 2 set skip_bd=1
 If %s% == 3 set skip_bd=1
 If %s% == 4 set skip_bd=0
 If %s% == 5 set skip_bd=1
 If %s% == 6 set skip_bd=0
 If %s% == 7 set skip_bd=1
 If %s% == 8 set skip_bd=1
 If %s% == 9 set skip_bd=0 
 If %s% == 10 set skip_bd=1
 If %s% == 11 set skip_bd=0
 If %s% == 12 set skip_bd=1
 If %s% == 13 set skip_bd=6
 If %s% == 14 set skip_bd=15
 If %s% == 15 set skip_bd=2
 goto :EOF

::
:: Without Black Section
::
:: On Calman we skip black pattern
::
:pattern_to_skip_on_calman_for_black
 If %s% == 1 set skip_c=1
 If %s% == 2 set skip_c=1
 If %s% == 3 set skip_c=1
 If %s% == 4 set skip_c=0
 If %s% == 5 set skip_c=1
 If %s% == 6 set skip_c=0
 If %s% == 7 set skip_c=1
 If %s% == 8 set skip_c=1
 If %s% == 9 set skip_c=0
 If %s% == 10 set skip_c=1
 If %s% == 11 set skip_c=0
 If %s% == 12 set skip_c=1
 If %s% == 13 set skip_c=6
 If %s% == 14 set skip_c=15
 If %s% == 15 set skip_c=2
 If %workflow_has_not_black% == 1 set skip_c=0
goto :EOF

::
:: Without Black Section
::
:: Function to check if sleep or send next to calman
::
:to_sleep
 set sleep_bd=0
 set sleep_c=0
 If %i% == %uno_bd% set sleep_bd=1
 If %i% == %due_bd% set sleep_bd=1
 If %i% == %tre_bd% set sleep_bd=1
 If %i% == %quattro_bd% set sleep_bd=1
 If %i% == %uno_c% set sleep_c=1
 If %i% == %due_c% set sleep_c=1
 If %i% == %tre_c% set sleep_c=1
 If %i% == %quattro_c% set sleep_c=1
goto :EOF

::
:: 
:: Function to get instructions
::
:get_instructions
 If %s% == 1 set instructions1=Please locate the 11-Point Grayscale measurements layout page!LF! of your workflow and click to select the 100%% White from your Source Slider.
 If %s% == 1 set instructions2= Start the disk chapter and press any key when you will see!LF! the 100%% White Info Patch Screen to your display...
 If %s% == 1 If %skip_black% == 1 set instructions1=Please locate the 11-Point Grayscale measurements layout page!LF! of your workflow and click to select the 0%% Black from your Source Slider.
 If %s% == 1 If %skip_black% == 1 set instructions2= Start the disk chapter and press any key when you will see!LF! the 0%% Black Info Patch Screen to your display...
 
 If %s% == 2 set instructions1=Please locate the 21-Point Grayscale measurements layout page!LF! of your workflow and click to select the 100%% White from your Source Slider.
 If %s% == 2 set instructions2= Start the disk chapter and press any key when you will see!LF! the 100%% White Patch Info Screen to your display...
 If %s% == 2 If %skip_black% == 1 set instructions1=Please locate the 21-Point Grayscale measurements layout page!LF! of your workflow and click to select the 0%% Black from your Source Slider.
 If %s% == 2 If %skip_black% == 1 set instructions2= Start the disk chapter and press any key when you will see!LF! the 0%% Black Info Patch Screen to your display...
 
 If %s% == 3 set instructions1=Please locate the 4-Point Saturation measurements layout page!LF! of your workflow and click to select the 0%% Black from your Source Slider.
 If %s% == 3 set instructions2= Start the disk chapter and press any key when you will see!LF! the 0%% Black Patch Info Screen to your display...

 If %s% == 4 set instructions1=Please locate the 4-Point Saturation measurement layout page of Color!LF! Comparator Comparisons workflow and click to select the White from your!LF! Source Slider.
 If %s% == 4 set instructions2= Start the disk chapter; skip the 0%% Black measurement and press any key when!LF! you will see the 100%% White Info Patch Screen to your display...

 If %s% == 5 set instructions1=Please locate the 5-Point Saturation measurements layout page!LF! of your workflow! and click to select the 0%% Black from your Source Slider.
 If %s% == 5 set instructions2= Start the disk chapter and press any key when you will see!LF! the 0%% Black Info Patch Screen to your display...

 If %s% == 6 set instructions1=Please locate the 5-Point Saturation measurement layout page of Color!LF! Comparator Comparisons workflow and click to select the White from your!LF! Source Slider.
 If %s% == 6 set instructions2= Start the disk chapter; skip the 0%% Black measurement and press any key when!LF! you will see the 100%% White Info Patch Screen to your display...
 
 If %s% == 7 set instructions1=Please locate the 10-Point Saturation measurements layout page!LF! of your workflow and click to select the 0%% Black from your Source Slider.
 If %s% == 7 set instructions2= Start the disk chapter and press any key when you will see!LF! the 0%% Black Info Patch Screen to your display...
 
 If %s% == 8 set instructions1=Please locate the 4-Point Luminance measurements layout page!LF! of your workflow and click to select the 0%% Black from your Source Slider.
 If %s% == 8 set instructions2= Start the disk chapter and press any key when you will see!LF! the 0%% Black Info Patch Screen to your display...

 If %s% == 9 set instructions1=Please locate the 4-Point Luminance measurement layout page of Color!LF! Comparator Comparisons workflow and click to select the White from your!LF! Source Slider.
 If %s% == 9 set instructions2= Start the disk chapter; skip the 0%% Black, 25%% Gray, 50%% Gray and 75%% Gray!LF! measurements and press any key when you will see the 100%% White Info Patch!LF! Screen to your display...
 
 If %s% == 10 set instructions1=Please locate the 5-Point Luminance measurements layout page!LF! of your workflow and click to select the 0%% Black from your Source Slider.
 If %s% == 10 set instructions2= Start the disk chapter and press any key when you will see!LF! the 0%% Black Info Patch Screen to your display...

 If %s% == 11 set instructions1=Please locate the 5-Point Luminance measurement layout page of Color!LF! Comparator Comparisons workflow and click to select the White from your!LF! Source Slider.
 If %s% == 11 set instructions2= Start the disk chapter; skip the 0%% Black, 25%% Gray, 50%% Gray and 75%% Gray!LF! measurements and press any key when you will see the 100%% White Info Patch!LF! Screen to your display...
 
 If %s% == 12 set instructions1=Please locate the 10-Point Luminance measurements layout page!LF! of your workflow and click to select the 0%% Black from your Source Slider.
 If %s% == 12 set instructions2= Start the disk chapter and press any key when you will see!LF! the 0%% Black Info Patch Screen to your display...

 If %s% == 13 set instructions1=Please locate the ColorChecker Classic measurements layout page!LF! of your workflow and click to select the White from your Source Slider.
 If %s% == 13 set instructions2= Start the disk chapter and press any key when you will see!LF! the White Info Patch Screen to your display...

 If %s% == 14 set instructions1=Please locate the ColorChecker SG measurements layout page!LF! of your workflow and click to select the White from your Source Slider.
 If %s% == 14 set instructions2= Start the disk chapter and press any key when you will see!LF! the White Info Patch Screen to your display...

 If %s% == 15 set instructions1=Please locate the ColorChecker SG Skintones measurements layout page!LF! of your workflow and click to select the White from your Source Slider.
 If %s% == 15 set instructions2= Start the disk chapter and press any key when you will see!LF! the White Info Patch Screen to your display...
goto :EOF

::
:: 
:: Function to sleep for info disappeared
::
:sleep_info_disappear
 call :get_duration
 set /a pr_timeout=%usec_menu%-%diff%
 if %debug% == 1 echo|set /p=Sleep for info menu %pr_timeout%...>>%log_file%
 set last_sleep=%pr_timeout%
 bin\usleep %pr_timeout% 
 if %debug% == 1 echo done>>%log_file%
goto :EOF

::
:: 
:: Function for skip calman pattern
::
:skip_calman_pattern
 set entered=1
 if %debug% == 1 echo|set /p=Skip Calman pattern...>>%log_file%
 start /B /wait cmd /C script\sendkey.%ext% %window_name% {ALTDOWN}{RIGHT}{ALTUP} >nul
 if %debug% == 1 echo done>>%log_file%
goto :EOF

::
:: 
:: Function to wait for black pattern to disappear
::
:wait_for_pattern_disappeared
 set entered=1
 call :get_duration
 set /a remove=%diff%-%last_sleep%
 set /a pr_timeout=%timeout_sleep%-%remove%
 set last_sleep=%pr_timeout%
 if %debug% == 1 echo|set /p=Sleep for skipped pattern %pr_timeout%...>>%log_file%
 bin\usleep %pr_timeout%
 if %debug% == 1 echo done>>%log_file%
goto :EOF

::
:: 
:: Function to get sleep for next pattern
::
:get_dynamic_sleep
 call :get_duration
 set /a remove=%diff%-%last_sleep%
 set /a pr_timeout=%timeout_sleep%-%remove%
 set last_sleep=%pr_timeout%
 if %debug% == 1 echo|set /p=Sleep for next pattern %pr_timeout%...>>%log_file%
 bin\usleep %pr_timeout%
 if %debug% == 1 echo done>>%log_file%
goto :EOF

::
:: 
:: Function to read calman pattern
::
:read_calman_pattern
 if %debug% == 1 call :get_last_pattern_time>>%log_file%
 set calman_shortcut={F5}
 If %s% == 1 If %i% == 2 If %skip_black% == 0 set calman_shortcut={ALTDOWN}0{ALTUP}
 If %s% == 2 If %i% == 2 If %skip_black% == 0 set calman_shortcut={ALTDOWN}0{ALTUP}
 if %debug% == 1 echo|set /p=Reading pattern (from last reading %diff_p% passed)...>>%log_file%
 start /B /wait cmd /C script\sendkey.%ext% %window_name% %calman_shortcut% >nul
 if %debug% == 1 echo done>>%log_file%
goto EOF

::
:: 
:: Function for end loop
::
:all_is_done
 call :get_duration
 set /a duration=(%ENDTIME%-%START_PROGRAM%)/100
 if %debug% == 1 echo Program executed in: %duration% seconds>>%log_file%
goto :main

::
:: 
:: Function to get duration
::
:get_duration
 set ENDTIME=%TIME%
 if " "=="%ENDTIME:~0,1%" set ENDTIME=0%ENDTIME:~-10%
 set /a ENDTIME=(1%ENDTIME:~0,2%-100)*360000+(1%ENDTIME:~3,2%-100)*6000+(1%ENDTIME:~6,2%-100)*100+(1%ENDTIME:~9,2%-100)
 if %STARTTIME% NEQ 0 set /A diff=(%ENDTIME%-%STARTTIME%)*10000
 set STARTTIME=%TIME%
 if " "=="%STARTTIME:~0,1%" set STARTTIME=0%STARTTIME:~-10%
 set /A STARTTIME="(1%STARTTIME:~0,2%-100)*360000 + (1%STARTTIME:~3,2%-100)*6000 + (1%STARTTIME:~6,2%-100)*100 + (1%STARTTIME:~9,2%-100)"
 if %START_PROGRAM% == 0 set START_PROGRAM=%STARTTIME%
goto :EOF

::
:: 
:: Function to get last pattern time
::
:get_last_pattern_time
 set ENDTIME_P=%TIME%
 if " "=="%ENDTIME_P:~0,1%" set ENDTIME_P=0%ENDTIME_P:~-10%
 set /a ENDTIME_P=(1%ENDTIME_P:~0,2%-100)*360000+(1%ENDTIME_P:~3,2%-100)*6000+(1%ENDTIME_P:~6,2%-100)*100+(1%ENDTIME_P:~9,2%-100)
 if %STARTTIME_P% NEQ 0 set /A diff_p=(%ENDTIME_P%-%STARTTIME_P%)*10000
 set STARTTIME_P=%TIME%
 if " "=="%STARTTIME_P:~0,1%" set STARTTIME_P=0%STARTTIME_P:~-10%
 set /A STARTTIME_P="(1%STARTTIME_P:~0,2%-100)*360000 + (1%STARTTIME_P:~3,2%-100)*6000 + (1%STARTTIME_P:~6,2%-100)*100 + (1%STARTTIME_P:~9,2%-100)"
goto :EOF

::
:: 
:: Function to initialize variables
::
:initialize_variables
 set START_PROGRAM=0
 set ENDTIME=0
 set ENDTIME_P=0
 set STARTTIME=0
 set STARTTIME_P=0
 set diff=0
 set diff_p=0
 set last_sleep=0
call:EOF